<?php
/**
*Plugin Name: bLoyal Account Management Tabs
*Plugin URI:
*Description: Embed bLoyal Account Management and Club Signup Snippets as tabs on the WooCommerce Account Management page.
*Version: 1.0.510.02
*Author:  bLoyal
*/
ob_clean();
ob_start();

add_action( 'init', 'add_bloyal_endpoint' );
function add_bloyal_endpoint() {
	add_rewrite_endpoint( 'loyalty-account', EP_ROOT | EP_PAGES );
}

add_filter( 'query_vars', 'custom_bloyal_query_vars', 0 );
function custom_bloyal_query_vars( $vars ) {
    $vars[] = 'loyalty-account';
    return $vars;
}

add_filter( 'woocommerce_account_menu_items', 'custom_add_loyalty_link_my_account', 20);
function custom_add_loyalty_link_my_account( $menu_links ) {
	$bloyal_tab = array( 'loyalty-account' => 'Account Management' );
	$menu_links = array_slice( $menu_links, 0, 1, true ) + $bloyal_tab + array_slice( $menu_links, 1, NULL, true );
    return $menu_links;
}

add_action( 'woocommerce_account_loyalty-account_endpoint', 'custom_bloyal_content' );
function custom_bloyal_content() {
	echo do_shortcode('[bloyal_ACCTMGMT_WC]');
}

?>
